/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.html;

import icyllis.annotations.NotNull;
import icyllis.annotations.Nullable;
import icyllis.flexmark.util.html.Attribute;
import icyllis.flexmark.util.html.Attributes;
import icyllis.flexmark.util.html.HtmlAppendable;
import icyllis.flexmark.util.html.MutableAttributes;
import icyllis.flexmark.util.misc.BitFieldSet;
import icyllis.flexmark.util.misc.Utils;
import icyllis.flexmark.util.sequence.BasedSequence;
import icyllis.flexmark.util.sequence.Escaping;
import icyllis.flexmark.util.sequence.LineAppendable;
import icyllis.flexmark.util.sequence.LineAppendableImpl;
import icyllis.flexmark.util.sequence.LineInfo;
import icyllis.flexmark.util.sequence.RepeatedSequence;
import icyllis.flexmark.util.sequence.builder.ISequenceBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class HtmlAppendableBase<T extends HtmlAppendableBase<T>>
implements HtmlAppendable {
    private final LineAppendable appendable;
    @Nullable
    private MutableAttributes currentAttributes;
    private boolean indentOnFirstEol = false;
    private boolean lineOnChildText = false;
    private boolean withAttributes = false;
    private boolean suppressOpenTagLine = false;
    private boolean suppressCloseTagLine = false;
    @NotNull
    private final Stack<String> openTags = new Stack();

    public HtmlAppendableBase(LineAppendable other, boolean inheritIndent) {
        this(other, inheritIndent ? other.getIndentPrefix().length() : 0, other.getOptions());
    }

    public HtmlAppendableBase(int indentSize, int formatOptions) {
        this(null, indentSize, formatOptions);
    }

    public HtmlAppendableBase(@Nullable Appendable other, int indentSize, int formatOptions) {
        this.appendable = new LineAppendableImpl(other, formatOptions);
        this.appendable.setIndentPrefix(RepeatedSequence.repeatOf(" ", indentSize).toString());
    }

    @Override
    @NotNull
    public HtmlAppendable getEmptyAppendable() {
        return new HtmlAppendableBase<T>(this.appendable, this.appendable.getIndentPrefix().length(), this.appendable.getOptions());
    }

    public boolean isSuppressOpenTagLine() {
        return this.suppressOpenTagLine;
    }

    public void setSuppressOpenTagLine(boolean suppressOpenTagLine) {
        this.suppressOpenTagLine = suppressOpenTagLine;
    }

    public boolean isSuppressCloseTagLine() {
        return this.suppressCloseTagLine;
    }

    @NotNull
    public T setSuppressCloseTagLine(boolean suppressCloseTagLine) {
        this.suppressCloseTagLine = suppressCloseTagLine;
        return (T)this;
    }

    @NotNull
    public String toString() {
        return this.appendable.toString();
    }

    @NotNull
    public T openPre() {
        this.appendable.openPreFormatted(true);
        return (T)this;
    }

    @NotNull
    public T closePre() {
        this.appendable.closePreFormatted();
        return (T)this;
    }

    @Override
    public boolean inPre() {
        return this.appendable.isPreFormatted();
    }

    private boolean haveOptions(int options) {
        return (this.appendable.getOptions() & options) != 0;
    }

    @NotNull
    public T raw(@NotNull CharSequence s2) {
        this.appendable.append(s2);
        return (T)this;
    }

    @NotNull
    public T raw(@NotNull CharSequence s2, int count) {
        int i = count;
        while (i-- > 0) {
            this.appendable.append(s2);
        }
        return (T)this;
    }

    @NotNull
    public T rawPre(@NotNull CharSequence s2) {
        if (this.appendable.getPendingEOL() == 0 && s2.length() > 0 && s2.charAt(0) == '\n') {
            this.appendable.line();
            s2 = s2.subSequence(1, s2.length());
        }
        this.appendable.openPreFormatted(true).append(s2).closePreFormatted();
        return (T)this;
    }

    @NotNull
    public T rawIndentedPre(@NotNull CharSequence s2) {
        this.appendable.openPreFormatted(true).append(s2).closePreFormatted();
        return (T)this;
    }

    @NotNull
    public T text(@NotNull CharSequence s2) {
        this.appendable.append(Escaping.escapeHtml(s2, false));
        return (T)this;
    }

    @NotNull
    public T attr(@NotNull CharSequence attrName, @NotNull CharSequence value) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new MutableAttributes();
        }
        this.currentAttributes.addValue(attrName, value);
        return (T)this;
    }

    @NotNull
    public T attr(Attribute ... attribute) {
        if (this.currentAttributes == null) {
            this.currentAttributes = new MutableAttributes();
        }
        for (Attribute attr : attribute) {
            this.currentAttributes.addValue(attr.getName(), attr.getValue());
        }
        return (T)this;
    }

    @NotNull
    public T attr(@NotNull Attributes attributes) {
        if (!attributes.isEmpty()) {
            if (this.currentAttributes == null) {
                this.currentAttributes = new MutableAttributes(attributes);
            } else {
                this.currentAttributes.addValues(attributes);
            }
        }
        return (T)this;
    }

    @NotNull
    public T withAttr() {
        this.withAttributes = true;
        return (T)this;
    }

    @Override
    public Attributes getAttributes() {
        return this.currentAttributes;
    }

    @NotNull
    public T setAttributes(@NotNull Attributes attributes) {
        this.currentAttributes = attributes.toMutable();
        return (T)this;
    }

    @NotNull
    public T withCondLineOnChildText() {
        this.lineOnChildText = true;
        return (T)this;
    }

    @NotNull
    public T withCondIndent() {
        this.indentOnFirstEol = true;
        return (T)this;
    }

    @NotNull
    public T tag(@NotNull CharSequence tagName) {
        return (T)this.tag(tagName, false);
    }

    @NotNull
    public T tag(@NotNull CharSequence tagName, @NotNull Runnable runnable) {
        return (T)this.tag(tagName, false, false, runnable);
    }

    @NotNull
    public T tagVoid(@NotNull CharSequence tagName) {
        return (T)this.tag(tagName, true);
    }

    protected String getOpenTagText() {
        return Utils.splice(this.openTags, ", ", true);
    }

    protected void pushTag(CharSequence tagName) {
        this.openTags.push(String.valueOf(tagName));
    }

    protected void popTag(CharSequence tagName) {
        if (this.openTags.isEmpty()) {
            throw new IllegalStateException("Close tag '" + tagName + "' with no tags open");
        }
        String openTag = this.openTags.peek();
        if (!openTag.equals(String.valueOf(tagName))) {
            throw new IllegalStateException("Close tag '" + tagName + "' does not match '" + openTag + "' in " + this.getOpenTagText());
        }
        this.openTags.pop();
    }

    protected void tagOpened(CharSequence tagName) {
        this.pushTag(tagName);
    }

    protected void tagClosed(CharSequence tagName) {
        this.popTag(tagName);
    }

    @Override
    @NotNull
    public Stack<String> getOpenTags() {
        return this.openTags;
    }

    @Override
    @NotNull
    public List<String> getOpenTagsAfterLast(@NotNull CharSequence latestTag) {
        int iMax;
        if (this.openTags.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> tagList = new ArrayList<String>(this.openTags);
        int lastPos = iMax = tagList.size();
        String lastTag = String.valueOf(latestTag);
        int i = iMax;
        while (i-- > 0) {
            if (!((String)tagList.get(i)).equals(lastTag)) continue;
            lastPos = i + 1;
            break;
        }
        return tagList.subList(lastPos, iMax);
    }

    @NotNull
    public T tag(@NotNull CharSequence tagName, boolean voidElement) {
        if (tagName.length() == 0 || tagName.charAt(0) == '/') {
            return (T)this.closeTag(tagName);
        }
        MutableAttributes attributes = null;
        if (this.withAttributes) {
            attributes = this.currentAttributes;
            this.currentAttributes = null;
            this.withAttributes = false;
        }
        this.appendable.append("<");
        this.appendable.append(tagName);
        if (attributes != null && !attributes.isEmpty()) {
            for (Attribute attribute : attributes.values()) {
                String attributeValue = attribute.getValue();
                if (attribute.isNonRendering()) continue;
                this.appendable.append(" ");
                this.appendable.append(Escaping.escapeHtml(attribute.getName(), true));
                this.appendable.append("=\"");
                this.appendable.append(Escaping.escapeHtml(attributeValue, true));
                this.appendable.append("\"");
            }
        }
        if (voidElement) {
            this.appendable.append(" />");
        } else {
            this.appendable.append(">");
            this.tagOpened(tagName);
        }
        return (T)this;
    }

    @NotNull
    public T closeTag(@NotNull CharSequence tagName) {
        if (tagName.length() == 0) {
            throw new IllegalStateException("closeTag called with tag:'" + tagName + "'");
        }
        if (tagName.charAt(0) == '/') {
            this.appendable.append("<").append(tagName).append(">");
            this.tagClosed(tagName.subSequence(1, tagName.length()));
        } else {
            this.appendable.append("</").append(tagName).append(">");
            this.tagClosed(tagName);
        }
        return (T)this;
    }

    @NotNull
    public T tag(@NotNull CharSequence tagName, boolean withIndent, boolean withLine, @NotNull Runnable runnable) {
        boolean isLineOnChildText = this.lineOnChildText;
        boolean isIndentOnFirstEol = this.indentOnFirstEol;
        this.lineOnChildText = false;
        this.indentOnFirstEol = false;
        if (withIndent && !this.suppressOpenTagLine) {
            this.appendable.line();
        }
        this.tag(tagName, false);
        if (withIndent && !isIndentOnFirstEol) {
            this.appendable.indent();
        }
        if ((this.appendable.getOptions() & F_PASS_THROUGH) != 0) {
            runnable.run();
        } else {
            boolean[] hadConditionalIndent = new boolean[]{false};
            Runnable indentOnFirstEol = () -> {
                hadConditionalIndent[0] = true;
            };
            if (isLineOnChildText) {
                this.appendable.setLineOnFirstText();
            }
            if (isIndentOnFirstEol) {
                this.appendable.addIndentOnFirstEOL(indentOnFirstEol);
            }
            runnable.run();
            if (isLineOnChildText) {
                this.appendable.clearLineOnFirstText();
            }
            if (hadConditionalIndent[0]) {
                this.appendable.unIndentNoEol();
            } else {
                this.appendable.removeIndentOnFirstEOL(indentOnFirstEol);
            }
        }
        if (withIndent && !isIndentOnFirstEol) {
            this.appendable.unIndent();
        }
        if (withLine && !this.suppressCloseTagLine) {
            this.appendable.line();
        }
        this.closeTag(tagName);
        if (withIndent && !this.suppressCloseTagLine) {
            this.appendable.line();
        }
        return (T)this;
    }

    @NotNull
    public T tagVoidLine(@NotNull CharSequence tagName) {
        ((HtmlAppendableBase)((HtmlAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tagVoid(tagName)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    @NotNull
    public T tagLine(@NotNull CharSequence tagName) {
        ((HtmlAppendableBase)((HtmlAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    @NotNull
    public T tagLine(@NotNull CharSequence tagName, boolean voidElement) {
        ((HtmlAppendableBase)((HtmlAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName, voidElement)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    @NotNull
    public T tagLine(@NotNull CharSequence tagName, @NotNull Runnable runnable) {
        ((HtmlAppendableBase)((HtmlAppendableBase)this.lineIf(!this.suppressOpenTagLine)).tag(tagName, false, false, runnable)).lineIf(!this.suppressCloseTagLine);
        return (T)this;
    }

    @NotNull
    public T tagIndent(@NotNull CharSequence tagName, @NotNull Runnable runnable) {
        this.tag(tagName, true, false, runnable);
        return (T)this;
    }

    @NotNull
    public T tagLineIndent(@NotNull CharSequence tagName, @NotNull Runnable runnable) {
        this.tag(tagName, true, true, runnable);
        return (T)this;
    }

    @Override
    @NotNull
    public Iterator<LineInfo> iterator() {
        return this.appendable.iterator();
    }

    @Override
    @NotNull
    public Iterable<BasedSequence> getLines(int maxTrailingBlankLines, int startLine, int endLine, boolean withPrefixes) {
        return this.appendable.getLines(maxTrailingBlankLines, startLine, endLine, true);
    }

    @Override
    @NotNull
    public Iterable<LineInfo> getLinesInfo(int maxTrailingBlankLines, int startLine, int endLine) {
        return this.appendable.getLinesInfo(maxTrailingBlankLines, startLine, endLine);
    }

    @Override
    public void setPrefixLength(int lineIndex, int prefixEndIndex) {
        this.appendable.setPrefixLength(lineIndex, prefixEndIndex);
    }

    @Override
    public void insertLine(int lineIndex, @NotNull CharSequence prefix, @NotNull CharSequence text) {
        this.appendable.insertLine(lineIndex, prefix, text);
    }

    @Override
    public void setLine(int lineIndex, @NotNull CharSequence prefix, @NotNull CharSequence text) {
        this.appendable.setLine(lineIndex, prefix, text);
    }

    @Override
    public <T extends Appendable> T appendTo(@NotNull T out, boolean withPrefixes, int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) throws IOException {
        return this.appendable.appendTo(out, withPrefixes, maxBlankLines, maxTrailingBlankLines, startLine, endLine);
    }

    @Override
    public boolean endsWithEOL() {
        return this.appendable.endsWithEOL();
    }

    @Override
    public boolean isPendingSpace() {
        return this.appendable.isPendingSpace();
    }

    @Override
    public boolean isPreFormatted() {
        return this.appendable.isPreFormatted();
    }

    @Override
    public int getTrailingBlankLines(int endLine) {
        return this.appendable.getTrailingBlankLines(endLine);
    }

    @Override
    public int column() {
        return this.appendable.column();
    }

    @Override
    public int getLineCount() {
        return this.appendable.getLineCount();
    }

    @Override
    public int getLineCountWithPending() {
        return this.appendable.getLineCountWithPending();
    }

    @Override
    public int getOptions() {
        return this.appendable.getOptions();
    }

    @Override
    public int getPendingSpace() {
        return this.appendable.getPendingSpace();
    }

    @Override
    public int getPendingEOL() {
        return this.appendable.getPendingEOL();
    }

    @Override
    public int offset() {
        return this.appendable.offset();
    }

    @Override
    public int offsetWithPending() {
        return this.appendable.offsetWithPending();
    }

    @Override
    public int getAfterEolPrefixDelta() {
        return this.appendable.getAfterEolPrefixDelta();
    }

    @Override
    @NotNull
    public ISequenceBuilder<?, ?> getBuilder() {
        return this.appendable.getBuilder();
    }

    @Override
    @NotNull
    public BasedSequence getPrefix() {
        return this.appendable.getPrefix();
    }

    @Override
    @NotNull
    public BasedSequence getBeforeEolPrefix() {
        return this.appendable.getBeforeEolPrefix();
    }

    @Override
    @NotNull
    public LineInfo getLineInfo(int lineIndex) {
        return this.appendable.getLineInfo(lineIndex);
    }

    @Override
    @NotNull
    public BasedSequence getLine(int lineIndex) {
        return this.appendable.getLine(lineIndex);
    }

    @Override
    @NotNull
    public BasedSequence getIndentPrefix() {
        return this.appendable.getIndentPrefix();
    }

    @Override
    @NotNull
    public CharSequence toSequence(int maxBlankLines, int maxTrailingBlankLines, boolean withPrefixes) {
        return this.appendable.toSequence(maxBlankLines, maxTrailingBlankLines, withPrefixes);
    }

    @Override
    @NotNull
    public String toString(int maxBlankLines, int maxTrailingBlankLines, boolean withPrefixes) {
        return this.appendable.toString(maxBlankLines, maxTrailingBlankLines, withPrefixes);
    }

    @Override
    @NotNull
    public BitFieldSet<LineAppendable.Options> getOptionSet() {
        return this.appendable.getOptionSet();
    }

    @NotNull
    public T removeExtraBlankLines(int maxBlankLines, int maxTrailingBlankLines, int startLine, int endLine) {
        this.appendable.removeExtraBlankLines(maxBlankLines, maxTrailingBlankLines, startLine, endLine);
        return (T)this;
    }

    @NotNull
    public T removeLines(int startLine, int endLine) {
        this.appendable.removeLines(startLine, endLine);
        return (T)this;
    }

    @NotNull
    public T pushOptions() {
        this.appendable.pushOptions();
        return (T)this;
    }

    @NotNull
    public T popOptions() {
        this.appendable.popOptions();
        return (T)this;
    }

    @NotNull
    public T changeOptions(int addFlags, int removeFlags) {
        this.appendable.changeOptions(addFlags, removeFlags);
        return (T)this;
    }

    @NotNull
    public T addIndentOnFirstEOL(@NotNull Runnable listener) {
        this.appendable.addIndentOnFirstEOL(listener);
        return (T)this;
    }

    @NotNull
    public T addPrefix(@NotNull CharSequence prefix) {
        this.appendable.addPrefix(prefix);
        return (T)this;
    }

    @NotNull
    public T addPrefix(@NotNull CharSequence prefix, boolean afterEol) {
        this.appendable.addPrefix(prefix, afterEol);
        return (T)this;
    }

    @NotNull
    public T append(char c) {
        this.appendable.append(c);
        return (T)this;
    }

    @NotNull
    public T append(@NotNull CharSequence csq) {
        this.appendable.append(csq);
        return (T)this;
    }

    @NotNull
    public T append(@NotNull CharSequence csq, int start, int end) {
        this.appendable.append(csq, start, end);
        return (T)this;
    }

    @NotNull
    public T append(@NotNull LineAppendable lines, int startLine, int endLine, boolean withPrefixes) {
        this.appendable.append(lines, startLine, endLine, withPrefixes);
        return (T)this;
    }

    @NotNull
    public T blankLine() {
        this.appendable.blankLine();
        return (T)this;
    }

    @NotNull
    public T blankLine(int count) {
        this.appendable.blankLine(count);
        return (T)this;
    }

    @NotNull
    public T blankLineIf(boolean predicate) {
        this.appendable.blankLineIf(predicate);
        return (T)this;
    }

    @NotNull
    public T closePreFormatted() {
        this.appendable.closePreFormatted();
        return (T)this;
    }

    @NotNull
    public T indent() {
        this.appendable.indent();
        return (T)this;
    }

    @NotNull
    public T line() {
        this.appendable.line();
        return (T)this;
    }

    @NotNull
    public T lineIf(boolean predicate) {
        this.appendable.lineIf(predicate);
        return (T)this;
    }

    @NotNull
    public T lineOnFirstText(boolean value) {
        this.appendable.lineOnFirstText(value);
        return (T)this;
    }

    @NotNull
    public T lineWithTrailingSpaces(int count) {
        this.appendable.lineWithTrailingSpaces(count);
        return (T)this;
    }

    @NotNull
    public T openPreFormatted(boolean keepIndent) {
        this.appendable.openPreFormatted(keepIndent);
        return (T)this;
    }

    @NotNull
    public T popPrefix() {
        this.appendable.popPrefix();
        return (T)this;
    }

    @NotNull
    public T popPrefix(boolean afterEol) {
        this.appendable.popPrefix(afterEol);
        return (T)this;
    }

    @NotNull
    public T pushPrefix() {
        this.appendable.pushPrefix();
        return (T)this;
    }

    @NotNull
    public T removeIndentOnFirstEOL(@NotNull Runnable listener) {
        this.appendable.removeIndentOnFirstEOL(listener);
        return (T)this;
    }

    @NotNull
    public T append(char c, int count) {
        this.appendable.append(c, count);
        return (T)this;
    }

    @NotNull
    public T setIndentPrefix(@Nullable CharSequence prefix) {
        this.appendable.setIndentPrefix(prefix);
        return (T)this;
    }

    @NotNull
    public T setOptions(int flags) {
        this.appendable.setOptions(flags);
        return (T)this;
    }

    @NotNull
    public T setPrefix(@NotNull CharSequence prefix) {
        this.appendable.setPrefix(prefix);
        return (T)this;
    }

    @NotNull
    public T setPrefix(@Nullable CharSequence prefix, boolean afterEol) {
        this.appendable.setPrefix(prefix, afterEol);
        return (T)this;
    }

    @NotNull
    public T unIndent() {
        this.appendable.unIndent();
        return (T)this;
    }

    @NotNull
    public T unIndentNoEol() {
        this.appendable.unIndentNoEol();
        return (T)this;
    }
}

